<?php
/**
 * Singleton. 'User Approve' Data Access Object
 *
 * @author Aybat Duyshokov <duyshokov@gmail.com>
 * @package ow_system_plugins.base.bol
 * @since 1.0
 */
class BOL_UserApproveDao extends OW_BaseDao
{

    /**
     * Constructor.
     *
     */
    protected function __construct()
    {
        parent::__construct();
    }
    /**
     * Singleton instance.
     *
     * @var BOL_UserApproveDao
     */
    private static $classInstance;

    /**
     * Returns an instance of class (singleton pattern implementation).
     *
     * @return BOL_UserApproveDao
     */
    public static function getInstance()
    {
        if ( self::$classInstance === null )
        {
            self::$classInstance = new self();
        }

        return self::$classInstance;
    }

    /**
     * @see OW_BaseDao::getDtoClassName()
     *
     */
    public function getDtoClassName()
    {
        return 'BOL_UserDisapprove';
    }

    /**
     * @see OW_BaseDao::getTableName()
     *
     */
    public function getTableName()
    {
        return OW_DB_PREFIX . 'base_user_disapprove';
    }

    public function findByUserId( $userId )
    {
        $ex = new OW_Example();
        $ex->andFieldEqual('userId', $userId);

        return $this->findObjectByExample($ex);
    }

    public function deleteByUserId( $userId )
    {
        $ex = new OW_Example();
        $ex->andFieldEqual('userId', $userId);

        return $this->deleteByExample($ex);
    }

    public function findUnapproveStatusForUserList( $idList )
    {
        if (!is_array($idList) || empty($idList)) {
            return array();
        }
        $query = "SELECT `userId` FROM `" . $this->getTableName() . "`
            WHERE `userId` IN (" . $this->dbo->mergeInClause($idList) . ")";

        return $this->dbo->queryForColumnList($query);
    }
}