<?php
/**
 * Oembed attachment
 *
 * @package ow_system_plugins.base.components
 * @since 1.0
 */
class BASE_CMP_AjaxOembedAttachment extends OW_Component
{
    protected $oembed = array(), $uniqId;

    public function __construct( $oembed )
    {
        parent::__construct();

        $this->uniqId = IISSecurityProvider::generateUniqueId('eqattachment');
        $this->assign('uniqId', $this->uniqId);
        $iisEventSecurity = new OW_Event('iissecurityessentials.on.check.url.embed', array('oembed'=>$oembed));
        OW::getEventManager()->trigger($iisEventSecurity);
        if(isset($iisEventSecurity->getData()['noContent'])){
            $this->assign('noContent',$iisEventSecurity->getData()['noContent']);
        }
        $this->oembed = $oembed;
    }

    public function initJs()
    {
        $js = UTIL_JsGenerator::newInstance();
        $js->newObject(array('OW_AttachmentItemColletction', $this->uniqId), 'OW_Attachment', array($this->uniqId, $this->oembed));

        OW::getDocument()->addOnloadScript($js);

        return $this->uniqId;
    }

    public function onBeforeRender()
    {
        parent::onBeforeRender();

        $this->assign('data', $this->oembed);
    }
}
