<?php
class iisdatabackupTest extends IISTestUtilites
{
    private $TEST_USERNAME = 'adminForLoginTest';
    private $TEST_EMAIL = 'admin@gmail.com';
    private $TEST_CORRECT_PASSWORD = 'asdf@1111';

    private $user;

    protected function setUp()
    {
        parent::setUp();
        $this->checkRequiredPlugins(array('iisdatabackup'));
        ensure_session_active();
        $accountType = BOL_QuestionService::getInstance()->getDefaultAccountType()->name;
        IISSecurityProvider::createUser($this->TEST_USERNAME,$this->TEST_EMAIL,$this->TEST_CORRECT_PASSWORD,"1987/3/21","1",$accountType,'c0de');
        $this->user = BOL_UserService::getInstance()->findByUsername($this->TEST_USERNAME);

        self::markTestSkipped('too many changes is required');
    }

    public function testPostDataBackup()
    {
        //self::markTestSkipped('test failures');
        $this->webDriver->prepare();
        $this->webDriver->maximizeWindow();
        $this->url(OW_URL_HOME . "dashboard");

        $sessionId = $this->webDriver->getCookie(OW_Session::getInstance()->getName())['value'];
        $sessionId = str_replace('%2C', ',', $sessionId); // fixes  '/^[-,a-zA-Z0-9]{1,128}$/'
        $this->sign_in($this->user->getUsername(),$this->TEST_CORRECT_PASSWORD,true,true,$sessionId);
        srand(time());
        $number = rand();
        try{

            $this->hide_element('demo-nav');
            $this->byName('status')->value('selenium status'.$number);
            $this->byName('save')->submit();
            $this->waitUntilElementLoaded('byCssSelector','.ow_newsfeed_string.ow_small.ow_smallmargin');
            $this->moveto( $this->byCssSelector('.ow_newsfeed_string.ow_small.ow_smallmargin'));
            $webdriver = $this;

            $this->moveto( $this->byCssSelector('.ow_newsfeed_context_menu_wrap'));

            $this->moveto( $this->byCssSelector('.ow_context_more'));
            $this->moveto($this->byXPath("//*[contains(@class, 'newsfeed_remove_btn owm_red_btn')]"));
            $this->byXPath("//*[contains(@class, 'newsfeed_remove_btn owm_red_btn')]")->click();
            $this->acceptAlert();
            $this->waitUntilElementLoaded('byName','status');
            $this->byName('status')->value('selenium status2');
            $this->byName('save')->submit();
            $this->waitUntilElementLoaded('byCssSelector','.ow_button');
            $this->waitUntil(function() use($webdriver){
                try{
                    $webdriver->byCssSelector('.ow_newsfeed_string.ow_small.ow_smallmargin');
                    return true;
                }catch (Exception $ex){
                    return null;
                }

            }, 10000);
            $backupTable = OW::getDbo()->queryForRow('show tables like :tableName', array('tableName' => IISSecurityProvider::getTableBackupName(OW_DB_PREFIX.'newsfeed_status')));
            if (!empty($backupTable)) {
                $queryForGetData = "select * from ".IISSecurityProvider::getTableBackupName(OW_DB_PREFIX.'newsfeed_status')." where status = 'selenium status".$number."'";
                $data = OW::getDbo()->queryForRow($queryForGetData);
                if($data)
                {
                    self::assertTrue(true);
                }
                else
                {
                    self::assertTrue(false);
                }
            }
        }catch (Exception $ex){
            $this->handleException($ex,'',true,false);
        }
    }

    public function testCommentPostDataBackup()
    {
        $this->webDriver->prepare();
        $this->webDriver->maximizeWindow();
        $this->url(OW_URL_HOME . "dashboard");

        $sessionId = $this->webDriver->getCookie(OW_Session::getInstance()->getName())['value'];
        $sessionId = str_replace('%2C', ',', $sessionId); // fixes  '/^[-,a-zA-Z0-9]{1,128}$/'
        $this->sign_in($this->user->getUsername(),$this->TEST_CORRECT_PASSWORD,true,true,$sessionId);
        srand(time());
        $number = rand();
        try{
            $this->hide_element('demo-nav');
            $this->byName('status')->value('selenium status'.$number);
            $this->byName('save')->submit();
            $webdriver = $this;
            $this->waitUntilElementLoaded('byCssSelector','.ow_miniic_comment.newsfeed_comment_btn');
            $this->moveto($this->byCssSelector('.ow_miniic_comment.newsfeed_comment_btn'));
            $this->byCssSelector('.ow_miniic_comment.newsfeed_comment_btn')->click();
            $this->byClassName('comments_fake_autoclick')->value('selenium comment'.$number);
            $this->keys(PHPUnit_Extensions_Selenium2TestCase_Keys::ENTER);
            $this->waitUntilElementLoaded('byClassName','ow_comments_item_header');

            $this->moveto( $this->byClassName('ow_comments_item_header'));
            $this->moveto($this->byCssSelector('.cnx_action'));
            $this->moveto($this->byCssSelector('.ow_comments_context_tooltip'));
            $this->byClassName('ow_comments_context_tooltip')->click();
            $this->acceptAlert();
            $this->waitUntil(function() use($webdriver){
                try{
                    $count = $webdriver->byClassName('newsfeed_counter_comments')->text();
                    if($count==0) {
                        return true;
                    }
                }catch (Exception $ex){
                    $this->handleException($ex,'',true,false);
                }

            }, 5000);
            $backupTable = OW::getDbo()->queryForRow('show tables like :tableName', array('tableName' => IISSecurityProvider::getTableBackupName(OW_DB_PREFIX.'base_comment')));
            if (!empty($backupTable)) {
                $queryForGetData = "select * from `".IISSecurityProvider::getTableBackupName(OW_DB_PREFIX.'base_comment')."` where message ='selenium comment".$number."'";
                $data = OW::getDbo()->queryForRow($queryForGetData);
                if($data)
                {
                    self::assertTrue(true);
                }
                else
                {
                    self::assertTrue(false);
                }
            }
            self::assertTrue(true);
        }catch (Exception $ex){
            $this->handleException($ex,'iisdatabackupTest.testCommentPost',true);
        }
    }

    public function tearDown()
    {
        if($this->isSkipped)
            return;

        //delete users
        IISSecurityProvider::deleteUser($this->user->getUsername());
        parent::tearDown();
    }
}