<?php
/**
 * @author Seyed Ismail Mirvakili
 * Date: 7/12/2017
 * Time: 11:00 AM
 */
class isForceChangableTest extends IISUnitTestUtilites
{
    private $backupConfigValue;
    protected function setUp()
    {
        parent::setUp();
        $this->backupConfigValue = OW::getConfig()->getValue('iispasswordchangeinterval', 'dealWithExpiredPassword');
    }

    public function test()
    {
        OW::getConfig()->saveConfig('iispasswordchangeinterval', 'dealWithExpiredPassword',IISPASSWORDCHANGEINTERVAL_BOL_Service::DEAL_WITH_EXPIRED_PASSWORD_NORMAL_WITHOUT_NOTIF);
        //it should not change by force because dealWithExpiredPassword is normal
        self::assertFalse(IISPASSWORDCHANGEINTERVAL_BOL_Service::getInstance()->isForceChangable());

        OW::getConfig()->saveConfig('iispasswordchangeinterval', 'dealWithExpiredPassword',IISPASSWORDCHANGEINTERVAL_BOL_Service::DEAL_WITH_EXPIRED_PASSWORD_NORMAL_WITH_NOTIF);
        //it should not change by force because dealWithExpiredPassword is normal_notif
        self::assertFalse(IISPASSWORDCHANGEINTERVAL_BOL_Service::getInstance()->isForceChangable());

        OW::getConfig()->saveConfig('iispasswordchangeinterval', 'dealWithExpiredPassword',IISPASSWORDCHANGEINTERVAL_BOL_Service::DEAL_WITH_EXPIRED_PASSWORD_FORCE_WITH_NOTIF);
        //it should not change by force because dealWithExpiredPassword is force_notif
        self::assertTrue(IISPASSWORDCHANGEINTERVAL_BOL_Service::getInstance()->isForceChangable());

        OW::getConfig()->saveConfig('iispasswordchangeinterval', 'dealWithExpiredPassword','none');
        //it should not change by force because dealWithExpiredPassword is invalid
        self::assertFalse(IISPASSWORDCHANGEINTERVAL_BOL_Service::getInstance()->isForceChangable());
    }


    protected function tearDown()
    {
        parent::tearDown();
        OW::getConfig()->saveConfig('iispasswordchangeinterval', 'dealWithExpiredPassword',$this->backupConfigValue);
    }


}