package ir.iiscenter.shub;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import java.io.File;

/**
 * Created by Alimardani on 11/1/2016.
 */

public class ChromeClient extends WebChromeClient {

    private MainActivity mainActivity;

    public ChromeClient(Context context) {
        if (context != null) {
            if (context instanceof MainActivity) {
                mainActivity = (MainActivity) context;
            }
        }
    }

    public void openFileChooser(ValueCallback<Uri> uploadMsg, String acceptType) {
        if(mainActivity==null){
            return;
        }

        mainActivity.mUploadMessage = uploadMsg;
        startActivityOpenChooser(acceptType);
    }

    public void startActivityOpenChooser(String acceptType){
        File imageStorageDir = new File(mainActivity.getExternalCacheDir(), "user_upload_files");

        if (!imageStorageDir.exists()) {
            // Create user_upload_files at sdcard
            imageStorageDir.mkdirs();
        }

        // Create camera captured image file path and name
        File file = new File(imageStorageDir + File.separator + "IMG_" + String.valueOf(System.currentTimeMillis()) + ".jpg");
        mainActivity.mCapturedImageURI = Uri.fromFile(file);

        // Camera capture image intent
        final Intent captureIntent = new Intent(android.provider.MediaStore.ACTION_IMAGE_CAPTURE);
        captureIntent.putExtra(MediaStore.EXTRA_OUTPUT, mainActivity.mCapturedImageURI);

        Intent i = new Intent(Intent.ACTION_GET_CONTENT);
        i.addCategory(Intent.CATEGORY_OPENABLE);
        if(acceptType.equals("image/*")){
            i.setType(acceptType);
        }else{
            i.setType("*/*");
        }

        // Create file chooser intent
        Intent chooserIntent = Intent.createChooser(i, mainActivity.getResources().getString(R.string.choose_file_for_upload));

        // Set camera intent to file chooser
        chooserIntent.putExtra(Intent.EXTRA_INITIAL_INTENTS, new Parcelable[]{captureIntent});

        // On select image call onActivityResult method of activity
        mainActivity.startActivityForResult(chooserIntent, MainActivity.FILECHOOSER_RESULTCODE);
    }

    // openFileChooser for Android < 3.0
    public void openFileChooser(ValueCallback<Uri> uploadMsg) {
        openFileChooser(uploadMsg, "");
    }

    // openFileChooser for Android >= 3.0
    public void openFileChooser(ValueCallback<Uri> uploadMsg, String acceptType, String capture) {
        openFileChooser(uploadMsg, acceptType);
    }

    @Override
    public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> filePathCallback, WebChromeClient.FileChooserParams fileChooserParams) {
        if (mainActivity.mFilePathCallback != null) {
            mainActivity.mFilePathCallback.onReceiveValue(null);
        }
        mainActivity.mFilePathCallback = filePathCallback;
        startActivityOpenChooser("");
        return true;
    }
}