package ir.iiscenter.shub;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.net.ConnectivityManager;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.support.design.widget.FloatingActionButton;
import android.support.v4.view.ViewCompat;
import android.util.DisplayMetrics;
import android.view.SubMenu;
import android.view.View;
import android.support.design.widget.NavigationView;
import android.support.v4.view.GravityCompat;
import android.support.v4.widget.DrawerLayout;
import android.support.v7.app.ActionBarDrawerToggle;
import android.support.v7.app.AppCompatActivity;
import android.support.v7.widget.Toolbar;
import android.view.Menu;
import android.view.MenuItem;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.webkit.CookieManager;
import android.webkit.ValueCallback;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import com.asha.ChromeLikeSwipeLayout;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MainActivity extends AppCompatActivity
        implements NavigationView.OnNavigationItemSelectedListener, View.OnClickListener {

    private WebView webView;
    private ArrayList<MyMenuItem> mainMenuItems;
    private ArrayList<MyMenuItem> footerMenuItems;
    private ArrayList<MyMenuItem> languageMenuItems;
    private ChromeLikeSwipeLayout swipeContainer;
    private Typeface font;
    private WebSettings webSettings;
    private ImageButton user_avatar;
    private ImageButton register_image;
    private ImageButton sign_in_image;
    private NavigationView navigationView;
    private User user;
    private FloatingActionButton profileMenu;
    private boolean doubleBackToExitPressedOnce = false;
    private boolean profileMenuClicked = false;
    private ConnectivityReceiver connectivityReceiver;
    public ValueCallback<Uri> mUploadMessage;
    public Uri mCapturedImageURI = null;
    public ValueCallback<Uri[]> mFilePathCallback;
    public String mCameraPhotoPath;
    public static final int INPUT_FILE_REQUEST_CODE = 1;
    public static final int FILECHOOSER_RESULTCODE = 1;
    public List<String> validHistoryUrls = new ArrayList<>();

    public ChromeLikeSwipeLayout getSwipeContainer() {
        if(swipeContainer==null){
            swipeContainer = (ChromeLikeSwipeLayout) findViewById(R.id.swipeContainer);
        }
        return swipeContainer;
    }

    public FloatingActionButton getProfileMenu() {
        if(profileMenu == null){
            profileMenu = (FloatingActionButton) findViewById(R.id.profileMenu);
        }
        return profileMenu;
    }

    public LinearLayout getUpdateDialogLayout() {
        return (LinearLayout) findViewById(R.id.update_dialog);
    }

    public NavigationView getNavigationView() {
        if(navigationView == null){
            navigationView = (NavigationView) findViewById(R.id.nav_view);
        }
        return navigationView;
    }

    public ImageButton getUserAvatar() {
        if(user_avatar == null){
            user_avatar = (ImageButton) getNavigationView().getHeaderView(0).findViewById(R.id.user_avatar);
        }
        return user_avatar;
    }

    public ImageButton getRegisterImage() {
        if(register_image == null){
            register_image = (ImageButton) getNavigationView().getHeaderView(0).findViewById(R.id.registerImage);
        }
        return register_image;
    }

    public ImageButton getSignInImage() {
        if(sign_in_image == null){
            sign_in_image = (ImageButton) getNavigationView().getHeaderView(0).findViewById(R.id.signInImage);
        }
        return sign_in_image;
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Config.getInstance(MainActivity.this);
        connectivityReceiver = new ConnectivityReceiver();
        connectivityReceiver.register(getApplicationContext(), new IntentFilter(ConnectivityManager.CONNECTIVITY_ACTION));

        setContentView(R.layout.activity_main);
        if (getIntent().getExtras() == null || (getIntent().getExtras().getString("languageTag") == null && getIntent().getExtras().getString("fromNotification") == null)) {
            changeLocale(null, null);
        } else {

            if (getCurrentLanguageTag() != null && getCurrentLanguageTag().toLowerCase().equals(Config.getInstance(MainActivity.this).getDefaultLanguageTag().toLowerCase())) {
                font = Typeface.createFromAsset(getAssets(), Config.getInstance(MainActivity.this).getPersianFontPath());
            }

            setWebview((WebView) findViewById(R.id.webview));
            getWebview().setWebViewClient(new ShubViewClient(this));
            getWebview().setWebChromeClient(new ChromeClient(this));
            getWebview().setImportantForAccessibility(View.IMPORTANT_FOR_ACCESSIBILITY_NO);

            hideProfileMenu();
            initializeUpdateDialogInformation();
            getProfileMenu().setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    profileMenuClicked = !profileMenuClicked;
                    getWebview().loadUrl("javascript:openRightSideBar()");
                }
            });

            Toolbar toolbar = (Toolbar) findViewById(R.id.toolbar);
            setSupportActionBar(toolbar);
            DrawerLayout drawer = (DrawerLayout) findViewById(R.id.drawer_layout);
            ActionBarDrawerToggle toggle = new ActionBarDrawerToggle(
                    this, drawer, toolbar, R.string.navigation_drawer_open, R.string.navigation_drawer_close);

            drawer.addDrawerListener(toggle);
            toggle.syncState();
            initApiVersion();

            webSettings = getWebview().getSettings();
            webSettings.setJavaScriptEnabled(true);
            webSettings.setLoadWithOverviewMode(true);
            webSettings.setUseWideViewPort(true);
            webSettings.setUserAgentString(Config.getInstance(MainActivity.this).getUserAgentDescription());
            webSettings.setAllowFileAccess(true);
            webSettings.setSaveFormData(true);
            webSettings.setDomStorageEnabled(true);

            // Temporarily disabling Scroll bars in WebView
            getWebview().setHorizontalScrollBarEnabled(false);
            getWebview().setVerticalScrollBarEnabled(false);

            CookieManager.getInstance().setCookie(Config.getInstance(MainActivity.this).getHomeUrl(), Config.getInstance(MainActivity.this).getUsingMobileAppCookie());

            CookieUtils.flushCookies();

            getNavigationView().setNavigationItemSelectedListener(this);

            setTitle(getResources().getString(R.string.app_name));

            String href = Config.getInstance(MainActivity.this).getHomeUrl();
            if (getIntent().getExtras() != null && getIntent().getExtras().getString("href") != null && !getIntent().getExtras().getString("href").equals("")) {
                href = getIntent().getExtras().getString("href");
            }

            getUserAvatar().setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    clickOnUserAvatar();
                }
            });

            getRegisterImage().setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    clickOnRegisterImage();
                }
            });

            getSignInImage().setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    clickOnSignInImage();
                }
            });

            initLoadingIndicator();
            initSwipeContainer();
            loadUrl(href, getWebview());
        }
    }

    protected void initSwipeContainer(){
        int refreshIcon = R.drawable.ic_menu_refresh_native;
        int closeIcon = R.drawable.ic_menu_close_native;
        int homeIcon = R.drawable.ic_menu_home_native;
        if (Build.VERSION.SDK_INT < Build.VERSION_CODES.LOLLIPOP) {
            refreshIcon = R.drawable.ic_menu_refresh_png;
            closeIcon = R.drawable.ic_menu_close_png;
            homeIcon = R.drawable.ic_menu_home_png;
        }

        getSwipeContainer().makeConfig()
                .addIcon(refreshIcon)
                .addIcon(closeIcon)
                .addIcon(homeIcon)
                .radius(65)
                .gap(20)
                .circleColor(0xFFED3237)
                .backgroundColor(0xFFFFFFFF)
                .gummyDuration(300)
                .rippleDuration(0)
                .setMaxHeight(100)
                .collapseDuration(100)
                .listenItemSelected(new ChromeLikeSwipeLayout.IOnItemSelectedListener() {
                    @Override
                    public void onItemSelected(int index) {
                        if(index == 0){
                            reload(MainActivity.this.getWebview());
                        }else if(index == 2){
                            loadUrl(Config.getInstance(MainActivity.this).getHomeUrl(),MainActivity.this.getWebview());
                        }
                    }
                })
                .setTo(getSwipeContainer());
    }

    @Override
    protected void onResume() {
        // Resuming the connectivityReceiver
        if (connectivityReceiver != null) {
            connectivityReceiver.register(getApplicationContext(), new IntentFilter(ConnectivityManager.CONNECTIVITY_ACTION));
        }
        super.onResume();
    }

    @Override
    protected void onPause() {
        // Unregister the connectivityReceiver for preventing Intent Receiver Leaked Exception
        if (connectivityReceiver != null) {
            connectivityReceiver.unregister(getApplicationContext());
        }
        super.onPause();
    }

    @Override
    protected void onStop() {
        // Unregister the connectivityReceiver for preventing Intent Receiver Leaked Exception
        if (connectivityReceiver != null) {
            connectivityReceiver.unregister(getApplicationContext());
        }
        super.onStop();
    }

    @Override
    public void onDestroy() {
        // Unregister the connectivityReceiver for preventing Intent Receiver Leaked Exception
        if (connectivityReceiver != null) {
            connectivityReceiver.unregister(getApplicationContext());
        }
        super.onDestroy();
    }

    //This function has been automatically called when user selects a file.
    @Override
    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            if (requestCode != INPUT_FILE_REQUEST_CODE || mFilePathCallback == null) {
                super.onActivityResult(requestCode, resultCode, data);
                return;
            }

            Uri[] results = null;

            // Check that the response is ok
            if (resultCode == Activity.RESULT_OK) {
                if (data == null) {
                    // If there is not data, then we may have taken a photo
                    if (mCameraPhotoPath != null) {
                        results = new Uri[]{Uri.parse(Uri.decode(mCameraPhotoPath))};
                    }else if(mCapturedImageURI != null){
                        results = new Uri[]{mCapturedImageURI};
                    }
                } else {
                    String dataString = data.getDataString();
                    if (dataString != null) {
                        results = new Uri[]{Uri.parse(Uri.decode(dataString))};
                    }
                }
            }

            mFilePathCallback.onReceiveValue(results);
            mFilePathCallback = null;
        } else if (Build.VERSION.SDK_INT <= Build.VERSION_CODES.KITKAT) {
            if (requestCode != FILECHOOSER_RESULTCODE || mUploadMessage == null) {
                super.onActivityResult(requestCode, resultCode, data);
                return;
            }

            if (requestCode == FILECHOOSER_RESULTCODE) {
                if (this.mUploadMessage == null) {
                    return;
                }

                Uri result = null;
                try {
                    if (resultCode != RESULT_OK) {
                        result = null;
                    } else {
                        // retrieve from the private variable if the intent is null
                        if (data == null) {
                            result = mCapturedImageURI;
                        } else {
                            result = data.getData();
                            result = Uri.fromFile(new File(UTIL.getRealPathFromURI(this, result)));
                        }
                    }
                } catch (Exception e) {
                    UTIL.showNotification(getResources().getString(R.string.error_on_upload_file), MainActivity.this, Toast.LENGTH_SHORT);
                }

                mUploadMessage.onReceiveValue(result);
                mUploadMessage = null;
            }
        }
    }


    public void showProfileMenu(){
        getProfileMenu().setVisibility(View.VISIBLE);
    }

    public void hideProfileMenu(){
        getProfileMenu().setVisibility(View.GONE);
    }

    /***
     * The page is loading.
     */
    public void pageStartToLoad(){
        hideProfileMenu();
        showLoadingIndicator();
    }

    /***
     * The page has been loaded.
     *
     * @param complete
     */
    public void loadingPageFinished(boolean complete){
        if(complete) {
            showProfileMenu();
        }
        hideLoadingIndicator();
    }

    /***
     * Go to the profile or sign-in page
     */
    public void clickOnUserAvatar() {
        if (user != null && user.profileUrl != null && !user.profileUrl.equals("")) {
            loadUrl(user.profileUrl, getWebview());
            closeMenu();
        }else{
            loadUrl(Config.getInstance(this).getSignInUrl(), getWebview());
            closeMenu();
        }
    }

    /***
     * Download latest version of app
     */
    public void clickOnDownloadLatestVersion(){
        Information information = Config.getInstance(this).getInformation();
        if(information==null || information.versionInformation.getLastVersionUrl().equals("")){
            UTIL.showNotification(this.getResources().getString(R.string.error_download_latest_version), this, Toast.LENGTH_LONG);
        }else{
            String latestVersionUrl = information.versionInformation.getLastVersionUrl();
            UTIL.downloadFile(latestVersionUrl, this);
        }
    }

    /***
     * Recheck current version
     */
    public void clickOnCheckCurrentVersion(){
        Intent intent = getIntent();
        finish();
        startActivity(intent);
    }

    /***
     * Go to the register page
     * It works only for guest users
     */
    public void clickOnRegisterImage(){
        if(user==null || user.email==null || user.email.equals("")){
            loadUrl(Config.getInstance(this).getJoinnUrl(), getWebview());
            closeMenu();
        }
    }

    /***
     * Go to the Sing-in page for the guest users
     * Go to the sign-out page for the logged-in users
     */
    public void clickOnSignInImage(){
        if(user==null || user.email==null || user.email.equals("")){
            loadUrl(Config.getInstance(this).getSignInUrl(), getWebview());
            closeMenu();
        }else{
            loadUrl(Config.getInstance(this).getSignOutUrl(), getWebview());
            closeMenu();
        }
    }

    /***
     * Close menu
     */
    public void closeMenu() {
        DrawerLayout drawer = (DrawerLayout) findViewById(R.id.drawer_layout);
        drawer.closeDrawer(GravityCompat.START);
    }

    /***
     * Component of menu is open or not
     */
    public boolean isMenuOpen() {
        DrawerLayout drawer = (DrawerLayout) findViewById(R.id.drawer_layout);
        return drawer.isDrawerOpen(GravityCompat.START);
    }

    /***
     * Return loading indicator component
     *
     * @return
     */
    public ImageView getLoadingIndicator(){
        return (ImageView) findViewById(R.id.loading);
    }

    /***
     * Initializing the component of loading indicator
     * Add flip animation to the component of loading indicator
     */
    public void initLoadingIndicator(){
        Animation myFlip = AnimationUtils.loadAnimation(this, R.anim.flip_anim);
        getLoadingIndicator().startAnimation(myFlip);
    }

    /***
     * Show Loading Indicator
     */
    public void showLoadingIndicator() {
        initLoadingIndicator();
    }

    /***
     * Hide Loading Indicator
     */
    public void hideLoadingIndicator() {
        getLoadingIndicator().clearAnimation();
    }

    /***
     * Set Locale of application
     *
     * @param tag
     * @param href
     */
    public void setLocale(String tag, String href) {
        if (!tag.equals("")) {
            if (!getCurrentLanguageTag().toLowerCase().equals(tag.toLowerCase())) {
                changeLocale(tag, href);
            } else {
                loadUrl(href, MainActivity.this.getWebview());
            }
        }
    }

    /***
     * Return current language tag of application
     *
     * @return
     */
    @SuppressWarnings("deprecation")
    public String getCurrentLanguageTag() {
        String currentLanguage;
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            currentLanguage = getResources().getConfiguration().getLocales().get(0).getLanguage();
        } else {
            currentLanguage = getResources().getConfiguration().locale.getLanguage();
        }

        return currentLanguage;
    }

    public void setLocale() {
        if (getIntent().getExtras() != null && getIntent().getExtras().getString("languageTag") != null && !getIntent().getExtras().getString("languageTag").equals("")) {
            updateConfigurationLocale(getIntent().getExtras().getString("languageTag"));
        }
    }

    /***
     * Change Locale of application using Language Tag
     *
     * @param languageTag
     * @param href
     */
    private void changeLocale(String languageTag, String href) {
        if (languageTag == null || languageTag.equals("")) {
            languageTag = Config.getInstance(MainActivity.this).getDefaultLanguageTag();
        }
        if (href == null) {
            href = "";
        }
        updateConfigurationLocale(languageTag);
        Intent intent = getIntent();
        intent.putExtra("languageTag", languageTag);
        intent.putExtra("href", href);
        restartActivity(intent);
    }

    /***
     * Update configuration of locale
     *
     * @param languageTag
     */
    @SuppressWarnings("deprecation")
    public void updateConfigurationLocale(String languageTag) {
        Resources res = MainActivity.this.getResources();
        DisplayMetrics dm = res.getDisplayMetrics();
        Configuration conf = res.getConfiguration();
        Locale locale = new Locale(languageTag);
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            conf.setLocale(locale);
        } else {
            conf.locale = locale;
        }
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.JELLY_BEAN_MR1) {
            conf.setLayoutDirection(locale);
        }
        res.updateConfiguration(conf, dm);
    }

    /***
     * Restart Current Activity
     *
     * @param intent
     */
    private void restartActivity(Intent intent) {
        finish();
        startActivity(intent);
    }

    /***
     *
     * @param newConfig
     */
    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        // refresh your views here
        super.onConfigurationChanged(newConfig);
    }

    /***
     * Load Web View using URL
     *
     * @param url
     * @param webview
     */
    public void loadUrl(String url, WebView webview) {
        if (webview != null) {
            if (!InternetConnection.checkNetworkConnection(this)) {
                createErrorOnLoadingMenuItem();
                UTIL.showNotification(getResources().getString(R.string.no_internet_label), MainActivity.this, Toast.LENGTH_SHORT);
                loadingPageFinished(false);
            } else {
                boolean shouldOverride = NavigationHelper.checkUrlForOverriding(url, false, MainActivity.this);
                if (!shouldOverride) {
                    clearWebviewCache(webview);
                    webView.loadUrl(url, getExtraHeader());
                }
            }
        }
    }

    public Map<String, String> getExtraHeader(){
        Map<String, String> extraHeaders = new HashMap<>();
        extraHeaders.put("Referer", getLastValidUrlFromHistory());
        return extraHeaders;
    }

    public String getLastValidUrlFromHistory(){
        if(validHistoryUrls.size()>0){
            return validHistoryUrls.get(validHistoryUrls.size()-1);
        }
        return Config.getInstance(this).getHomeUrl();
    }

    public void putValidUrlToHistory(String url){
        validHistoryUrls.add(url);
    }

    /***
     * Clear cache of webview
     *
     * @param webView
     */
    public void clearWebviewCache(WebView webView){
        if(Build.VERSION.SDK_INT <= Build.VERSION_CODES.JELLY_BEAN_MR2) {
            webView.clearCache(false);
        }
    }

    /***
     *
     * @param outState
     */
    @Override
    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        setLocale();
    }

    /***
     * Called automatically when back button pressed
     */
    @Override
    public void onBackPressed() {
        if(isMenuOpen()){
            closeMenu();
        }else {
            if(profileMenuClicked){
                getProfileMenu().callOnClick();
            }else if(doubleBackToExitPressedOnce){
                finish();
            }else {
                if (!MainActivity.this.getWebview().canGoBack()) {
                    doubleBackToExitPressedOnce = true;
                    UTIL.showNotification(getResources().getString(R.string.back_to_exit), MainActivity.this, Toast.LENGTH_SHORT);
                    new Handler().postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            doubleBackToExitPressedOnce=false;
                        }
                    }, 2000);
                }
                goBack(MainActivity.this.getWebview());
            }
        }
    }

    /***
     * Reload web view with current URL
     *
     * @param webview
     */
    public void reload(WebView webview) {
        if (webview != null) {
            if (!InternetConnection.checkNetworkConnection(this)) {
                UTIL.showNotification(getResources().getString(R.string.no_internet_label), MainActivity.this, Toast.LENGTH_SHORT);
            } else {
                if(webview.getUrl() == null || webview.getUrl().equals("about:blank")) {
                    loadUrl(Config.getInstance(MainActivity.this).getHomeUrl(), webview);
                } else {
                    webView.reload();
                }
            }
        }
    }

    /***
     * Support Back Button of Android Device to Reload Web View using Previous URL
     *
     * @param webview
     */
    public void goBack(WebView webview) {
        if (webview != null) {
            if (!InternetConnection.checkNetworkConnection(this)) {
                UTIL.showNotification(getResources().getString(R.string.no_internet_label), MainActivity.this, Toast.LENGTH_SHORT);
            } else {
                webView.goBack();
            }
        }
    }

    @Override
    public void onClick(View v) {
    }

    /***
     *
     * @param menu
     * @return
     */
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        return true;
    }

    /***
     *
     * @param item
     * @return
     */
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        return super.onOptionsItemSelected(item);
    }

    /***
     * Handle Navigation Item Selected
     *
     * @param item
     * @return
     */
    @SuppressWarnings("StatementWithEmptyBody")
    @Override
    public boolean onNavigationItemSelected(MenuItem item) {
        int id = item.getItemId();
        if (id == Config.getInstance(MainActivity.this).getApplicationExitCode()) {
            finish();
        } else if (id == -1) {
            return true;
        }else {
            String url = findUrlOfItemInMenu(id);
            if (url != null) {
                loadUrl(url, MainActivity.this.getWebview());
            }
            closeMenu();
        }
        return true;
    }

    public void manageDeprecatedVersion(){
        this.getWebview().stopLoading();
        hideLoadingIndicator();
        hideProfileMenu();
        findViewById(R.id.toolbar).setVisibility(View.GONE);
        getUpdateDialogLayout().setVisibility(View.VISIBLE);
    }

    /***
     * Reinitializing all information
     *
     * @param information
     */
    public void reconfigureInformation(Information information) {
        if(information != null) {
            Config.getInstance(this).setInformation(information);
            boolean isCurrentVersionDeprecated = information.versionInformation.isCurrentDeprecated();
            if (isCurrentVersionDeprecated) {
                this.manageDeprecatedVersion();
                return;
            }
        }

        TextView user_name = (TextView) getNavigationView().getHeaderView(0).findViewById(R.id.user_name);
        TextView user_email = (TextView) getNavigationView().getHeaderView(0).findViewById(R.id.user_email);

        if (information != null) {
            if (information.mainMenuItems != null && information.mainMenuItems.size() > 0) {
                mainMenuItems = information.mainMenuItems;
            }

            if (information.footerMenuItems != null && information.footerMenuItems.size() > 0) {
                footerMenuItems = information.footerMenuItems;
            }

            if (information.languageMenuItems != null && information.languageMenuItems.size() > 0) {
                languageMenuItems = information.languageMenuItems;
            }

            user = information.user;
            if (user != null) {
                user_name.setText(user.name);
                UTIL.setCustomFont(user_name, font);
                user_name.setVisibility(View.VISIBLE);

                user_email.setText(user.email);
                UTIL.setCustomFont(user_email, font);
                user_email.setVisibility(View.VISIBLE);

                getUserAvatar().setImageBitmap(user.avatar);

                getRegisterImage().setVisibility(View.GONE);

                getSignInImage().setImageResource(R.drawable.signout);
            } else{

                user_name.setVisibility(View.GONE);
                user_name.setText("");

                user_email.setText(getResources().getString(R.string.user_guest_label));
                UTIL.setCustomFont(user_email, font);
                user_email.setVisibility(View.VISIBLE);

                getUserAvatar().setImageResource(R.drawable.guest);

                getRegisterImage().setVisibility(View.VISIBLE);
                getSignInImage().setImageResource(R.drawable.signin);
            }
        } else {
            user = null;
            user_name.setVisibility(View.GONE);
            user_email.setVisibility(View.GONE);
            getUserAvatar().setImageResource(R.drawable.guest);
        }

        addMenuItemsToMenu();
        CookieUtils.flushCookies();
    }

    /***
     * Fetch All Menu Items From Server
     */
    public void fetchAllMenuItems() {
        AsyncTask<Context, Void, Information> response = new MenuFeedTask().execute(MainActivity.this);
    }

    /***
     * Add Fetched Menu Items to Menu
     */
    public void addMenuItemsToMenu() {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                getNavigationView().setItemIconTintList(null);
                Menu m = getNavigationView().getMenu();
                m.clear();
                if (MainActivity.this.mainMenuItems != null) {
                    SubMenu topChannelMenu = m.addSubMenu(UTIL.convertToCustomFont(getResources().getString(R.string.main_menu_label), font));
                    for (int i = 0; i < MainActivity.this.mainMenuItems.size(); i++) {
                        MyMenuItem item = MainActivity.this.mainMenuItems.get(i);
                        if (!UTIL.isInMenuBlackList(item.href, MainActivity.this)) {
                            MenuItem topMenuItem = topChannelMenu.add(Menu.NONE, item.label.hashCode(), i, item.label);
                            topMenuItem.setTitle(UTIL.convertToCustomFont(topMenuItem.getTitle(), font));
                            topMenuItem.setIcon(UTIL.getMenuIcon(item.href));
                        }
                    }
                }

                SubMenu bottomChannelMenu = m.addSubMenu(UTIL.convertToCustomFont(getResources().getString(R.string.footer_menu_label), font));
                int countOfButtomMenuItems = 0;
                if (MainActivity.this.footerMenuItems != null) {
                    for (int i = 0; i < MainActivity.this.footerMenuItems.size(); i++) {
                        MyMenuItem item = MainActivity.this.footerMenuItems.get(i);
                        if (!UTIL.isInMenuBlackList(item.href, MainActivity.this)) {
                            MenuItem bottomMenuItem = bottomChannelMenu.add(Menu.NONE, item.label.hashCode(), i, item.label);
                            bottomMenuItem.setTitle(UTIL.convertToCustomFont(bottomMenuItem.getTitle(), font));
                            bottomMenuItem.setIcon(UTIL.getMenuIcon(item.href));
                            countOfButtomMenuItems++;
                        }
                    }
                }

                //Add Exit Menu Item
                MenuItem exitMenuItem = bottomChannelMenu.add(Menu.NONE, Config.getInstance(MainActivity.this).getApplicationExitCode(), countOfButtomMenuItems, getResources().getString(R.string.exit_button_label));
                exitMenuItem.setTitle(UTIL.convertToCustomFont(exitMenuItem.getTitle(), font));
                exitMenuItem.setIcon(UTIL.getMenuIcon("exit"));


                if (MainActivity.this.languageMenuItems != null) {
                    SubMenu langChannelMenu = null;
                    if(MainActivity.this.languageMenuItems.size()>1) {
                        langChannelMenu = m.addSubMenu(UTIL.convertToCustomFont(getResources().getString(R.string.language_menu_label), font));
                    }
                    for (int i = 0; i < MainActivity.this.languageMenuItems.size(); i++) {
                        if(langChannelMenu!=null) {
                            MenuItem langMenuItem = langChannelMenu.add(Menu.NONE, MainActivity.this.languageMenuItems.get(i).label.hashCode(), i, MainActivity.this.languageMenuItems.get(i).label);
                            langMenuItem.setTitle(UTIL.convertToCustomFont(langMenuItem.getTitle(), font));
                            langMenuItem.setIcon(UTIL.getMenuIcon(MainActivity.this.languageMenuItems.get(i).tag));
                        }

                        //Checking current language tag
                        //It should happened just when app started.
                        if (MainActivity.this.languageMenuItems.get(i).is_current && getCurrentLanguageTag() != null && !MainActivity.this.languageMenuItems.get(i).tag.toLowerCase().equals(getCurrentLanguageTag().toLowerCase())) {
                            setLocale(MainActivity.this.languageMenuItems.get(i).tag, MainActivity.this.languageMenuItems.get(i).href);
                            return;
                        }
                    }
                }

                //Add Version Menu Item
                MenuItem versionMenuItem = m.add(Menu.NONE, -1, 1, getResources().getString(R.string.current_version) + BuildConfig.VERSION_NAME);
                versionMenuItem.setTitle(UTIL.convertToCustomFont(versionMenuItem.getTitle(), font));

                createErrorOnLoadingMenuItem();
            }

        });
    }

    /***
     * Initializing requirements of each version
     */
    public void initApiVersion(){
        if(Build.VERSION.SDK_INT <= Build.VERSION_CODES.JELLY_BEAN_MR1) {
            DrawerLayout drawer = (DrawerLayout) findViewById(R.id.drawer_layout);
            ViewCompat.setLayoutDirection(drawer, ViewCompat.LAYOUT_DIRECTION_LTR);
        }

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            CookieManager.getInstance().setAcceptCookie(true);
            CookieManager.getInstance().setAcceptThirdPartyCookies(getWebview(), true);
        }
    }

    /***
     * Create Error Menu Item Into Menu.
     */
    public void createErrorOnLoadingMenuItem() {
        if ((MainActivity.this.mainMenuItems == null || MainActivity.this.mainMenuItems.size() == 0) && (MainActivity.this.footerMenuItems == null || MainActivity.this.footerMenuItems.size() == 0) && (MainActivity.this.languageMenuItems == null || MainActivity.this.languageMenuItems.size() == 0)) {
            Menu m = getNavigationView().getMenu();
            if (m.size() == 0 || (m.size() == 1 && m.getItem(0).getSubMenu() != null && m.getItem(0).getSubMenu().size() == 2 && m.getItem(0).getSubMenu().getItem(0).getItemId() == Config.getInstance(MainActivity.this).getApplicationExitCode()) && m.getItem(0).getSubMenu().getItem(0).getItemId() == -1) {
                SubMenu topChannelMenu = m.addSubMenu(UTIL.convertToCustomFont(getResources().getString(R.string.menu_error_label), font));
                MenuItem errorMenuItem = topChannelMenu.add(Menu.NONE, getResources().getString(R.string.menu_item_error_label).hashCode(), 0, getResources().getString(R.string.menu_item_error_label));
                errorMenuItem.setTitle(UTIL.convertToCustomFont(errorMenuItem.getTitle(), font));
            }
        }
    }

    /***
     * Find Url of Menu Item Selected From Fetched Menu Items
     *
     * @param id
     * @return
     */
    public String findUrlOfItemInMenu(int id) {
        if (MainActivity.this.mainMenuItems != null) {
            for (int i = 0; i < MainActivity.this.mainMenuItems.size(); i++) {
                if (id == MainActivity.this.mainMenuItems.get(i).label.hashCode()) {
                    return MainActivity.this.mainMenuItems.get(i).href;
                }
            }
        }

        if (MainActivity.this.footerMenuItems != null) {
            for (int i = 0; i < MainActivity.this.footerMenuItems.size(); i++) {
                if (id == MainActivity.this.footerMenuItems.get(i).label.hashCode()) {
                    return MainActivity.this.footerMenuItems.get(i).href;
                }
            }
        }

        if (MainActivity.this.languageMenuItems != null) {
            for (int i = 0; i < MainActivity.this.languageMenuItems.size(); i++) {
                if (id == MainActivity.this.languageMenuItems.get(i).label.hashCode()) {
                    CookieManager.getInstance().setCookie(Config.getInstance(MainActivity.this).getHomeUrl(), "base_language_id=" + MainActivity.this.languageMenuItems.get(i).language_id);
                    CookieUtils.flushCookies();
                    setLocale(languageMenuItems.get(i).tag, MainActivity.this.languageMenuItems.get(i).href);
                    return null;
                }
            }
        }

        return Config.getInstance(MainActivity.this).getHomeUrl();
    }

    /***
     * Initialize layout of update dialog
     */
    public void initializeUpdateDialogInformation(){
        getUpdateDialogLayout().setVisibility(View.GONE);
        Button download_latest_version_button = (Button) getUpdateDialogLayout().findViewById(R.id.download_latest_version_button);
        UTIL.setCustomFont(download_latest_version_button, font);
        download_latest_version_button.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                clickOnDownloadLatestVersion();
            }
        });

        Button checkVersionButton = (Button) getUpdateDialogLayout().findViewById(R.id.check_version);
        UTIL.setCustomFont(checkVersionButton, font);
        checkVersionButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                clickOnCheckCurrentVersion();
            }
        });

        TextView downloadLatestVersionWarningText = (TextView) getUpdateDialogLayout().findViewById(R.id.download_latest_version_warning);
        UTIL.setCustomFont(downloadLatestVersionWarningText, font);
    }

    public WebView getWebview(){
        return webView;
    }

    public void setWebview(WebView webViewInput){
        webView = webViewInput;
    }
}